/******************************************************************************/
class BaseCheckVariable :  BaseEvent
{
public:
    BaseCheckVariable();
   ~BaseCheckVariable();
   
   virtual void AfterCreate();
   
protected: 
   void TriggerTrueCondition( );
   void TriggerFalseCondition();
   UID m_TrueUID, m_FalseUID;
    
private:  
   EventGroup* m_EventGroupTrue, *m_EventGroupFalse;
      
};
/******************************************************************************/
BaseCheckVariable::BaseCheckVariable() : m_EventGroupTrue(null), m_EventGroupFalse(null)              
{

}
BaseCheckVariable::~BaseCheckVariable()
{
   
}
/******************************************************************************/
void BaseCheckVariable::AfterCreate()
{
   m_EventGroupTrue  = GetEventGroupForID(m_TrueUID);
   m_EventGroupFalse = GetEventGroupForID(m_FalseUID);
}
/******************************************************************************/
void BaseCheckVariable::TriggerTrueCondition()
{
   if(m_EventGroupTrue != null)
   {
      m_EventGroupTrue.Triggered();
   }
}
/******************************************************************************/
void BaseCheckVariable::TriggerFalseCondition()
{
   if(m_EventGroupFalse != null)
   {
      m_EventGroupFalse.Triggered();
   }
}
/******************************************************************************/
